# Database Configuration - MySQL Setup

## Current Configuration

Your Laravel application is now configured to use MySQL with the following settings:

### Environment Variables (.env)
```
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=jtest
DB_USERNAME=root
DB_PASSWORD=
```

### Database Details
- **Database Name**: `jtest`
- **Host**: `127.0.0.1` (localhost)
- **Port**: `3306` (default MySQL port)
- **Username**: `root`
- **Password**: (empty)

## What Was Done

1. ✅ **Database Created**: MySQL database `jtest` has been created
2. ✅ **Migrations Run**: All database tables have been created in MySQL
3. ✅ **Sample Data Seeded**: Database populated with sample inventory data
4. ✅ **Application Ready**: Laravel server running on `http://localhost:8000`

## Database Tables Created

- `users` - User authentication
- `cache` - Application cache
- `jobs` - Queue jobs
- `products` - End products (e.g., lotion bottles)
- `raw_materials` - Raw materials (e.g., lotion base, bottles, labels)
- `product_raw_materials` - Relationship between products and raw materials
- `orders` - Orders from Shopify
- `order_items` - Items within each order

## Sample Data Included

- **3 Raw Materials**: Lotion Base (10L), Plastic Bottles (100 pieces), Product Labels (500 pieces)
- **1 Product**: Moisturizing Lotion with raw material requirements
- **2 Sample Orders**: Test orders with order items

## Accessing the Database

### Using MySQL Command Line
```bash
mysql -u root -p
USE jtest;
SHOW TABLES;
```

### Using phpMyAdmin (if installed with XAMPP)
1. Open `http://localhost/phpmyadmin`
2. Select database `jtest`
3. Browse tables and data

### Using Laravel Tinker
```bash
php artisan tinker
# Then run commands like:
# App\Models\Product::all()
# App\Models\RawMaterial::all()
# App\Models\Order::all()
```

## Troubleshooting

### If you get connection errors:
1. Make sure MySQL is running (XAMPP Control Panel)
2. Check if the database `jtest` exists
3. Verify MySQL credentials in `.env` file
4. Run `php artisan config:clear` to refresh configuration

### If you need to reset the database:
```bash
php artisan migrate:fresh --seed
```

## Next Steps

Your inventory management system is now ready to use with MySQL! You can:

1. **Access the application**: `http://localhost:8000`
2. **Add more raw materials**: Navigate to Raw Materials section
3. **Create products**: Define products and their raw material requirements
4. **Import orders**: Upload Shopify Excel files
5. **Monitor inventory**: Use the dashboard to track stock levels

The system will automatically calculate raw material consumption when orders are processed.
