# Shopify Order Import Guide

## Overview

This system allows you to import orders from Shopify exports and automatically manage inventory based on product line items. The system will:

1. Create orders with all line items
2. Automatically create products that don't exist
3. Match line items to products by SKU or name
4. Deduct raw materials from inventory based on product recipes
5. Alert you to inventory shortages

---

## Required Columns

Your Shopify export sheet **MUST** include these columns:

### Mandatory Columns:
- **`Name`** - Order number/identifier (e.g., #1001, #1002)
- **`Lineitem name`** - Product name for each line item
- **`Lineitem quantity`** - Quantity ordered

### Highly Recommended Columns:
- **`Email`** - Customer email
- **`Billing Name`** - Customer name
- **`Financial Status`** - Payment status (paid, pending, refunded, etc.)
- **`Fulfillment Status`** - Fulfillment status
- **`Lineitem sku`** - Product SKU (helps match products accurately)
- **`Lineitem price`** - Unit price
- **`Total`** - Order total amount

---

## Shopify Export Format

Shopify exports orders in a **line-item-per-row** format where:

- Each row represents **ONE line item** from an order
- Orders with multiple products will have **multiple rows**
- Common order data (Name, Email, Billing Name, Total, etc.) appears **only on the first row**
- Subsequent rows for the same order show **only line item data**

### Example Format:

```
Name  | Email              | Billing Name | Financial Status | Lineitem name | Lineitem quantity | Lineitem sku | Lineitem price | Total
------|-------------------|--------------|------------------|---------------|-------------------|--------------|----------------|-------
#1001 | john@example.com  | John Doe     | paid             | Product A     | 2                 | SKU-001      | 25.00          | 100.00
      |                   |              |                  | Product B     | 1                 | SKU-002      | 50.00          |
#1002 | jane@example.com  | Jane Smith   | paid             | Product C     | 3                 | SKU-003      | 15.00          | 45.00
```

**Note:** Empty cells in the second row of order #1001 are normal - the system will use data from the first row.

---

## How It Works

### 1. Order Processing
- Groups rows by order number (Name column)
- Creates one order per unique order number
- Processes all line items for each order

### 2. Product Matching
The system tries to find existing products in this order:

1. **First:** Match by `Lineitem sku` (if provided)
2. **Second:** Match by `Lineitem name` (exact match)
3. **If not found:** Creates a new product automatically

### 3. Inventory Management

For each order imported:

1. **Checks availability:** Calculates if you have enough raw materials
2. **Shows warnings:** Alerts you if any raw materials are insufficient
3. **Deducts inventory:** Updates raw material stock based on product recipes
4. **Allows negative stock:** Will proceed even if stock is insufficient (shows warnings)

**Important:** Products must have raw material recipes configured for inventory deduction to work. Products without recipes will be created but won't affect inventory.

---

## Import Process

### Step 1: Export from Shopify
1. Go to Shopify Admin → Orders
2. Click "Export"
3. Select the orders you want to export
4. Choose "Plain CSV file" or "Excel"
5. Ensure all required columns are included

### Step 2: Import in System
1. Navigate to the Import page in your system
2. Click "Choose File" and select your Shopify export
3. (Optional) Uncheck "Deduct Inventory" if you want to import without affecting stock
4. Click "Import Orders"

### Step 3: Review Results
The system will show:
- ✓ Number of orders created
- ✓ Number of line items processed
- ⚠️ Any inventory warnings (shortages)
- ❌ Any errors encountered

---

## Status Mapping

The system maps Shopify statuses to internal statuses:

### Financial Status → Order Status:
- `paid` → `processing`
- `pending` → `pending`
- `partially_paid` → `pending`
- `refunded` → `cancelled`
- `voided` → `cancelled`
- `partially_refunded` → `processing`

---

## Common Issues & Solutions

### Issue: "Required column 'X' not found"
**Solution:** Your Excel file is missing a required column. Ensure `Name`, `Lineitem name`, and `Lineitem quantity` columns exist with exact spelling.

### Issue: "Order already exists in the system"
**Solution:** This order number was already imported. The system prevents duplicate imports. If you need to re-import, delete the existing order first.

### Issue: "Line item quantity must be greater than 0"
**Solution:** One of your rows has a quantity of 0 or negative. Check your data and ensure all quantities are positive integers.

### Issue: Products created but inventory not deducted
**Solution:** Products need to have raw material recipes configured. Go to Products → Edit Product → Add Raw Materials to configure what materials are needed.

### Issue: Inventory warnings about shortages
**Solution:** This is normal if you don't have enough raw materials. The system will:
- Still create the order
- Still deduct inventory (resulting in negative stock)
- Alert you so you know to restock

---

## Best Practices

1. **Configure Product Recipes First**
   - Before importing orders, set up your products and their raw material requirements
   - This ensures accurate inventory tracking

2. **Regular Imports**
   - Import orders daily or as they come in
   - This keeps inventory tracking current

3. **Review Warnings**
   - Pay attention to inventory warnings
   - Restock raw materials when they get low

4. **Match by SKU**
   - Always include SKU column in your exports
   - SKU matching is more reliable than name matching

5. **Test First**
   - Try importing a small test file first
   - Download the sample template to see the correct format

6. **Backup Before Import**
   - Large imports can't be easily undone
   - Consider backing up your database before major imports

---

## Sample Template

Click "Download Order Template" in the Import page to get a properly formatted Excel template with sample data.

---

## Technical Details

### Inventory Calculation

For each order, the system:

1. Loads all order items (line items)
2. For each product in the order:
   - Gets the product's raw material recipe
   - Multiplies raw material quantities by order quantity
   - Aggregates all raw material requirements
3. Checks current stock levels
4. Deducts required amounts from raw material inventory

### Transaction Safety

All imports are wrapped in database transactions:
- If any order fails, none of the orders in that file are imported
- This prevents partial imports and data inconsistencies

### Product Auto-Creation

When a product doesn't exist:
- Creates with the name from "Lineitem name"
- Uses SKU from "Lineitem sku" or generates one
- Sets price from "Lineitem price"
- Marks as active by default
- **Doesn't have any raw materials** (you'll need to configure these manually)

---

## API Integration (Future)

If you want to automate imports, you can:

1. Export from Shopify via API
2. POST the file to `/import` endpoint
3. Include parameter `deduct_inventory=1` (default) or `0`

Contact your developer for API documentation.

---

## Support

If you encounter issues:

1. Check the error message carefully
2. Review this guide for common solutions
3. Verify your Excel file format matches the template
4. Contact support with the error message and a sample of your file

---

**Last Updated:** October 15, 2025
**Version:** 1.0

