# Product Import Guide

## Overview
You can now import products from Excel files using the Import page. This feature allows you to bulk upload products with just their Name and Price.

## How to Use

1. **Navigate to Import Page**
   - Go to `/import` in your application
   - Click on the "Import Products" tab

2. **Prepare Your Excel File**
   - Your Excel file should have two columns:
     - **Name**: The product name (required)
     - **Price**: The product price (required)
   
   Example:
   ```
   Name                | Price
   ---------------------|-------
   Product Name 1      | 29.99
   Product Name 2      | 49.99
   Product Name 3      | 19.99
   ```

3. **Download Template** (Optional)
   - Click the "Download Template" button to get a sample Excel file
   - This template shows the exact format needed

4. **Upload Your File**
   - Select your Excel file (.xlsx, .xls, or .csv)
   - Click "Import Products"
   - Wait for the import to complete

5. **Review Results**
   - After import, you'll see a summary showing:
     - Successfully imported products
     - Skipped products
     - Any errors that occurred

## Features

### Auto-Generated SKUs
- SKUs are automatically generated from product names
- Format: Product name converted to uppercase with dashes
- Example: "Blue Widget" becomes "BLUE-WIDGET"
- If a SKU already exists, a number is appended (e.g., "BLUE-WIDGET-1")

### Update Existing Products
- If a product with the same name already exists, only the price will be updated
- This allows you to easily update prices for existing products

### Price Formatting
- Prices can include currency symbols (e.g., $29.99, €49.99)
- Currency symbols and commas are automatically removed
- Decimal values are preserved

## Requirements

- File formats: .xlsx, .xls, or .csv
- Maximum file size: 10MB
- Required columns: Name, Price
- Column names are case-insensitive

## Tips

- Ensure all rows have both Name and Price filled in
- Empty rows will be skipped automatically
- If there are errors, they will be displayed after import
- You can import multiple times - existing products will have their prices updated

## Example Excel Format

You can use these column name variations:
- **Name**: "Name", "name", "Product Name", "Product"
- **Price**: "Price", "price", "Unit Price"

## Error Handling

Common errors and solutions:
- **"Product name is required"**: Make sure the Name column is not empty
- **"Price is required"**: Make sure the Price column is not empty
- **"Price cannot be negative"**: Use positive values for prices
- **"Required column not found"**: Check that your Excel file has "Name" and "Price" columns

## After Import

After successfully importing products:
1. Go to Products page to view all imported products
2. Edit any product to add additional details (description, stock levels, etc.)
3. Manage product raw materials if needed
4. Activate/deactivate products as needed

## Notes

- All imported products are set to "active" by default
- Initial stock levels are set to 0
- Minimum stock levels are set to 0
- You can update these values later through the Products page

