# Shopify Order Import - Column Reference

## Quick Reference: Mandatory Columns

Your Shopify export **MUST** have these exact column names:

1. **`Name`** - Order number/identifier (e.g., #1001, #1002)
2. **`Lineitem name`** - Product name for each line item
3. **`Lineitem quantity`** - Quantity ordered for each line item

---

## Complete Column List (Your Format)

Based on your Shopify export, here are all the columns you have:

| Column Name | Required | Purpose |
|------------|----------|---------|
| `Name` | ✓ Yes | Order number/identifier |
| `Email` | Recommended | Customer email address |
| `Billing Name` | Recommended | Customer's billing name |
| `Financial Status` | Recommended | Payment status (paid, pending, etc.) |
| `Fulfillment Status` | Optional | Shipping/fulfillment status |
| `Lineitem name` | ✓ Yes | Product name |
| `Lineitem quantity` | ✓ Yes | Quantity ordered |
| `Lineitem price` | Recommended | Unit price of the product |
| `Lineitem sku` | Recommended | Product SKU (for accurate matching) |
| `Total` | Recommended | Total order amount |

---

## Important Notes

### Multi-Line Item Format
When an order has multiple products:
- **First row:** Contains ALL order data (Name, Email, Billing Name, Total, etc.) + first line item
- **Subsequent rows:** Contains ONLY line item data (Lineitem name, quantity, price, sku)

**Example:**
```
Name  | Email            | Billing Name | Total  | Lineitem name | Lineitem quantity | Lineitem sku
------|------------------|--------------|--------|---------------|-------------------|-------------
#1001 | john@example.com | John Doe     | 100.00 | Product A     | 2                 | SKU-001
      |                  |              |        | Product B     | 1                 | SKU-002
```

### Product Matching Priority
1. System tries to match by `Lineitem sku` first
2. If no SKU match, tries `Lineitem name`
3. If no match found, creates a new product

### Inventory Management
- Products need raw material recipes configured for inventory tracking
- Without recipes, orders import but inventory won't be affected
- The system warns you if stock is insufficient but proceeds anyway

---

## Column Name Variations

The system is flexible with column names. These variations will also work:

- **Name** = "Order Number", "name"
- **Email** = "email", "Customer Email"
- **Billing Name** = "Name", "Customer Name"
- **Financial Status** = "Payment Status"
- **Total** = "total", "Order Total"

*Note: Line item columns must be exact: "Lineitem name", "Lineitem quantity", etc.*

---

**Last Updated:** October 15, 2025

