<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class RawMaterial extends Model
{
    protected $fillable = [
        'name',
        'description',
        'unit',
        'current_stock',
        'min_stock_level',
        'cost_per_unit',
        'is_active'
    ];

    protected $casts = [
        'current_stock' => 'decimal:2',
        'min_stock_level' => 'decimal:2',
        'cost_per_unit' => 'decimal:2',
        'is_active' => 'boolean'
    ];

    public function products(): BelongsToMany
    {
        return $this->belongsToMany(Product::class, 'product_raw_materials')
                    ->withPivot('quantity_required')
                    ->withTimestamps();
    }

    public function productRawMaterials(): HasMany
    {
        return $this->hasMany(ProductRawMaterial::class);
    }
}
