<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        //
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        // Register gates for all permissions
        Gate::before(function ($user, $ability) {
            // Check if the user has the permission through our custom system
            if ($user && method_exists($user, 'hasPermission')) {
                return $user->hasPermission($ability);
            }
        });
    }
}
