<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\RawMaterial;
use App\Models\Product;
use App\Models\Order;
use App\Models\OrderItem;

class InventorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create raw materials
        $lotion = RawMaterial::create([
            'name' => 'Lotion Base',
            'description' => 'Main lotion base ingredient',
            'unit' => 'liters',
            'current_stock' => 10.0,
            'min_stock_level' => 2.0,
            'cost_per_unit' => 15.50,
            'is_active' => true
        ]);

        $bottles = RawMaterial::create([
            'name' => 'Plastic Bottles',
            'description' => '250ml plastic bottles for lotion',
            'unit' => 'pieces',
            'current_stock' => 100,
            'min_stock_level' => 20,
            'cost_per_unit' => 0.75,
            'is_active' => true
        ]);

        $labels = RawMaterial::create([
            'name' => 'Product Labels',
            'description' => 'Waterproof product labels',
            'unit' => 'pieces',
            'current_stock' => 500,
            'min_stock_level' => 50,
            'cost_per_unit' => 0.10,
            'is_active' => true
        ]);

        // Create products
        $lotionProduct = Product::create([
            'name' => 'Moisturizing Lotion',
            'description' => 'Premium moisturizing lotion for dry skin',
            'sku' => 'LOTION-001',
            'price' => 12.99,
            'current_stock' => 25,
            'min_stock_level' => 5,
            'is_active' => true
        ]);

        // Attach raw materials to product
        $lotionProduct->rawMaterials()->attach($lotion->id, ['quantity_required' => 0.25]); // 0.25 liters per bottle
        $lotionProduct->rawMaterials()->attach($bottles->id, ['quantity_required' => 1]); // 1 bottle per product
        $lotionProduct->rawMaterials()->attach($labels->id, ['quantity_required' => 1]); // 1 label per product

        // Create sample orders
        $order1 = Order::create([
            'shopify_order_id' => 'SHOP-001',
            'customer_name' => 'John Doe',
            'customer_email' => 'john@example.com',
            'total_amount' => 25.98,
            'status' => 'pending',
            'order_date' => now()->subDays(2),
            'notes' => 'Sample order for testing'
        ]);

        OrderItem::create([
            'order_id' => $order1->id,
            'product_id' => $lotionProduct->id,
            'quantity' => 2,
            'unit_price' => 12.99,
            'total_price' => 25.98
        ]);

        $order2 = Order::create([
            'shopify_order_id' => 'SHOP-002',
            'customer_name' => 'Jane Smith',
            'customer_email' => 'jane@example.com',
            'total_amount' => 12.99,
            'status' => 'processing',
            'order_date' => now()->subDay(),
            'notes' => 'Another test order'
        ]);

        OrderItem::create([
            'order_id' => $order2->id,
            'product_id' => $lotionProduct->id,
            'quantity' => 1,
            'unit_price' => 12.99,
            'total_price' => 12.99
        ]);
    }
}