<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create permissions
        $permissions = [
            // Product permissions
            ['name' => 'View Products', 'slug' => 'view-products', 'description' => 'Can view products'],
            ['name' => 'Create Products', 'slug' => 'create-products', 'description' => 'Can create products'],
            ['name' => 'Edit Products', 'slug' => 'edit-products', 'description' => 'Can edit products'],
            ['name' => 'Delete Products', 'slug' => 'delete-products', 'description' => 'Can delete products'],
            
            // Inventory permissions
            ['name' => 'View Inventory', 'slug' => 'view-inventory', 'description' => 'Can view inventory'],
            ['name' => 'Manage Inventory', 'slug' => 'manage-inventory', 'description' => 'Can manage inventory'],
            ['name' => 'Import Inventory', 'slug' => 'import-inventory', 'description' => 'Can import inventory data'],
            
            // Order permissions
            ['name' => 'View Orders', 'slug' => 'view-orders', 'description' => 'Can view orders'],
            ['name' => 'Create Orders', 'slug' => 'create-orders', 'description' => 'Can create orders'],
            ['name' => 'Edit Orders', 'slug' => 'edit-orders', 'description' => 'Can edit orders'],
            ['name' => 'Delete Orders', 'slug' => 'delete-orders', 'description' => 'Can delete orders'],
            
            // User management permissions
            ['name' => 'View Users', 'slug' => 'view-users', 'description' => 'Can view users'],
            ['name' => 'Create Users', 'slug' => 'create-users', 'description' => 'Can create users'],
            ['name' => 'Edit Users', 'slug' => 'edit-users', 'description' => 'Can edit users'],
            ['name' => 'Delete Users', 'slug' => 'delete-users', 'description' => 'Can delete users'],
            ['name' => 'Manage Roles', 'slug' => 'manage-roles', 'description' => 'Can manage user roles'],
            
            // Reports permissions
            ['name' => 'View Reports', 'slug' => 'view-reports', 'description' => 'Can view reports'],
            ['name' => 'Export Data', 'slug' => 'export-data', 'description' => 'Can export data'],
        ];

        foreach ($permissions as $permission) {
            Permission::create($permission);
        }

        // Create roles
        $adminRole = Role::create([
            'name' => 'Administrator',
            'slug' => 'admin',
            'description' => 'Full system access with all permissions'
        ]);

        $managerRole = Role::create([
            'name' => 'Manager',
            'slug' => 'manager',
            'description' => 'Management access with limited administrative permissions'
        ]);

        // Assign all permissions to admin
        $adminRole->permissions()->attach(Permission::all());

        // Assign all permissions to manager as well
        $managerRole->permissions()->attach(Permission::all());

        // Create default admin user
        $adminUser = User::create([
            'name' => 'Administrator',
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
        ]);

        $adminUser->assignRole($adminRole);

        // Create default manager user
        $managerUser = User::create([
            'name' => 'Manager',
            'email' => 'manager@example.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
        ]);

        $managerUser->assignRole($managerRole);
    }
}
