@extends('layouts.app')

@section('title', 'Products.blade.php')
@section('page-title', 'Products.blade.php')

@section('content')
<div class="row">
    <div class="col-12">


    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3>Product Stock Analysis</h3>
            <a href="{{ route('products.index') }}" class="btn btn-outline-primary">
                <i class="fas fa-cog me-2"></i>Manage Products
            </a>
        </div>

        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Product</th>
                        <th>SKU</th>
                        <th>Price</th>
                        <th>Can Make</th>
                        <th>Raw Materials</th>
                        <th>Stock Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($products as $product)
                        @php
                            $canMake = $product->calculateCanMake();
                            $hasRawMaterials = $product->rawMaterials->count() > 0;
                            $stockStatus = $canMake > 0 ? 'success' : 'danger';
                            $stockText = $canMake > 0 ? 'Available' : 'Insufficient Materials';
                        @endphp
                        <tr>
                            <td>{{ $product->name }}</td>
                            <td>{{ $product->sku }}</td>
                            <td>${{ number_format($product->price, 2) }}</td>
                            <td>
                                <span class="badge bg-{{ $stockStatus }}">
                                    {{ $canMake }} units
                                </span>
                            </td>
                            <td>
                                @if($hasRawMaterials)
                                    <button type="button" class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#rawMaterialsModal{{ $product->id }}">
                                        View ({{ $product->rawMaterials->count() }})
                                    </button>
                                @else
                                    <span class="text-muted">None</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge bg-{{ $stockStatus }}">
                                    {{ $stockText }}
                                </span>
                            </td>
                            <td>
                                <a href="{{ route('products.show', $product) }}" class="btn btn-sm btn-outline-primary">View Details</a>
                            </td>
                        </tr>

                        <!-- Raw Materials Modal -->
                        <div class="modal fade" id="rawMaterialsModal{{ $product->id }}" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Raw Materials for {{ $product->name }}</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="table-responsive">
                                            <table class="table table-sm">
                                                <thead>
                                                    <tr>
                                                        <th>Raw Material</th>
                                                        <th>Unit</th>
                                                        <th>Quantity Required</th>
                                                        <th>Current Stock</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($product->rawMaterials as $rawMaterial)
                                                        <tr>
                                                            <td>{{ $rawMaterial->name }}</td>
                                                            <td>{{ $rawMaterial->unit }}</td>
                                                            <td>{{ $rawMaterial->pivot->quantity_required }}</td>
                                                            <td>{{ $rawMaterial->current_stock }}</td>
                                                            <td>
                                                                @php
                                                                    $required = $rawMaterial->pivot->quantity_required;
                                                                    $available = $rawMaterial->current_stock;
                                                                    $canMake = floor($available / $required);
                                                                @endphp
                                                                <span class="badge bg-{{ $canMake > 0 ? 'success' : 'danger' }}">
                                                                    Can make: {{ $canMake }} units
                                                                </span>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center">No products found. <a href="{{ route('products.create') }}">Add some products</a> to get started.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
                


    </div>
</div>
@endsection
