@extends('layouts.app')

@section('title', 'Raw materials.blade.php')
@section('page-title', 'Raw materials.blade.php')

@section('content')
<div class="row">
    <div class="col-12">


    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3>Raw Materials</h3>
            <a href="{{ route('raw-materials.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Add Raw Material
            </a>
        </div>

        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Unit</th>
                        <th>Current Stock</th>
                        <th>Min Stock Level</th>
                        <th>Cost per Unit</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($rawMaterials as $rawMaterial)
                        <tr>
                            <td>{{ $rawMaterial->name }}</td>
                            <td>{{ $rawMaterial->unit }}</td>
                            <td>{{ $rawMaterial->current_stock }}</td>
                            <td>{{ $rawMaterial->min_stock_level }}</td>
                            <td>${{ number_format($rawMaterial->cost_per_unit, 2) }}</td>
                            <td>
                                <span class="badge bg-{{ $rawMaterial->current_stock <= $rawMaterial->min_stock_level ? 'warning' : 'success' }}">
                                    {{ $rawMaterial->current_stock <= $rawMaterial->min_stock_level ? 'Low Stock' : 'OK' }}
                                </span>
                            </td>
                            <td>
                                <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#addStockModal{{ $rawMaterial->id }}">
                                    Add Stock
                                </button>
                                <a href="{{ route('raw-materials.edit', $rawMaterial) }}" class="btn btn-sm btn-outline-secondary">
                                    Edit
                                </a>
                            </td>
                        </tr>

                        <!-- Add Stock Modal -->
                        <div class="modal fade" id="addStockModal{{ $rawMaterial->id }}" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Add Stock - {{ $rawMaterial->name }}</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <form method="POST" action="{{ route('inventory.add-stock') }}">
                                        @csrf
                                        <div class="modal-body">
                                            <input type="hidden" name="raw_material_id" value="{{ $rawMaterial->id }}">
                                            <div class="mb-3">
                                                <label for="quantity" class="form-label">Quantity to Add</label>
                                                <input type="number" step="0.01" min="0.01" class="form-control" id="quantity" name="quantity" required>
                                                <div class="form-text">Current stock: {{ $rawMaterial->current_stock }} {{ $rawMaterial->unit }}</div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                            <button type="submit" class="btn btn-primary">Add Stock</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center">No raw materials found. <a href="{{ route('raw-materials.create') }}">Add some raw materials</a> to get started.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
                


    </div>
</div>
@endsection
