@extends('layouts.app')

@section('title', 'Orders')
@section('page-title', 'Orders')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3>Orders</h3>
            <div>
                <a href="{{ route('orders.returns') }}" class="btn btn-warning me-2">
                    <i class="fas fa-undo me-2"></i>View Returns
                </a>
                @can('create-orders')
                <a href="{{ route('orders.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add Order
                </a>
                @endcan
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Order ID</th>
                        <th>Customer</th>
                        <th>Email</th>
                        <th>Total Amount</th>
                        <th>Shipping</th>
                        <th>GST</th>
                        <th>WH Inc.Tax</th>
                        <th>WH Sales.Tax</th>
                        <th>Net Amount</th>
                        <th>Status</th>
                        <th>Order Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($orders as $order)
                        <tr>
                            <td>{{ $order->shopify_order_id }}</td>
                            <td>{{ $order->customer_name }}</td>
                            <td>{{ $order->customer_email ?: 'N/A' }}</td>
                            <td>Rs.{{ number_format($order->total_amount, 2) }}</td>
                            <td>
                                @if($order->shipping_charges)
                                    <span class="text-success">Rs.{{ number_format($order->shipping_charges, 2) }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($order->gst)
                                    <span class="text-danger">Rs.{{ number_format($order->gst, 2) }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($order->wh_inc_tax)
                                    <span class="text-danger">Rs.{{ number_format($order->wh_inc_tax, 2) }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($order->wh_sales_tax)
                                    <span class="text-danger">Rs.{{ number_format($order->wh_sales_tax, 2) }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($order->net_amount)
                                    <strong class="text-primary">Rs.{{ number_format($order->net_amount, 2) }}</strong>
                                    @if($order->courier_data_updated_at)
                                        <br><small class="text-muted" title="Last updated: {{ $order->courier_data_updated_at->format('M d, Y H:i') }}">
                                            <i class="fas fa-check-circle text-success"></i> Updated
                                        </small>
                                    @endif
                                @else
                                    <span class="text-warning">
                                        <i class="fas fa-clock"></i> Pending
                                    </span>
                                @endif
                            </td>
                            <td>
                                @if($order->returned_at)
                                    <span class="badge bg-danger">
                                        <i class="fas fa-undo me-1"></i>Returned
                                    </span>
                                    <br><small class="text-muted">{{ $order->returned_at->format('M d, Y') }}</small>
                                @else
                                    <span class="badge bg-{{ $order->status === 'pending' ? 'warning' : ($order->status === 'processing' ? 'info' : ($order->status === 'delivered' ? 'success' : 'secondary')) }}">
                                        {{ ucfirst($order->status) }}
                                    </span>
                                @endif
                            </td>
                            <td>{{ $order->order_date->format('M d, Y') }}</td>
                            <td>
                                <a href="{{ route('orders.show', $order) }}" class="btn btn-sm btn-outline-primary">View</a>
                                @can('edit-orders')
                                <a href="{{ route('orders.edit', $order) }}" class="btn btn-sm btn-outline-secondary">Edit</a>
                                @endcan
                                @can('delete-orders')
                                <form method="POST" action="{{ route('orders.destroy', $order) }}" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this order?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                </form>
                                @endcan
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="12" class="text-center">No orders found. 
                                @can('create-orders')
                                <a href="{{ route('orders.create') }}">Add some orders</a> or 
                                @endcan
                                @can('import-inventory')
                                <a href="{{ route('import.index') }}">import from Excel</a> to get started.
                                @endcan
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{ $orders->links() }}
    </div>
</div>
@endsection