@extends('layouts.app')

@section('title', 'Index.blade.php')
@section('page-title', 'Index.blade.php')

@section('content')
<div class="row">
    <div class="col-12">


    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3>Raw Materials</h3>
            <a href="{{ route('raw-materials.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Add Raw Material
            </a>
        </div>

        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Unit</th>
                        <th>Current Stock</th>
                        <th>Min Stock Level</th>
                        <th>Cost per Unit</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($rawMaterials as $rawMaterial)
                        <tr>
                            <td>{{ $rawMaterial->name }}</td>
                            <td>{{ $rawMaterial->unit }}</td>
                            <td>{{ $rawMaterial->current_stock }}</td>
                            <td>{{ $rawMaterial->min_stock_level }}</td>
                            <td>${{ number_format($rawMaterial->cost_per_unit, 2) }}</td>
                            <td>
                                <span class="badge bg-{{ $rawMaterial->current_stock <= $rawMaterial->min_stock_level ? 'warning' : 'success' }}">
                                    {{ $rawMaterial->current_stock <= $rawMaterial->min_stock_level ? 'Low Stock' : 'OK' }}
                                </span>
                            </td>
                            <td>
                                <a href="{{ route('raw-materials.show', $rawMaterial) }}" class="btn btn-sm btn-outline-primary">View</a>
                                <a href="{{ route('raw-materials.edit', $rawMaterial) }}" class="btn btn-sm btn-outline-secondary">Edit</a>
                                <form method="POST" action="{{ route('raw-materials.destroy', $rawMaterial) }}" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this raw material?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center">No raw materials found. <a href="{{ route('raw-materials.create') }}">Add some raw materials</a> to get started.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{ $rawMaterials->links() }}
    </div>
</div>
                

    </div>
</div>
@endsection
