<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ImportController;
use App\Http\Controllers\RawMaterialController;
use App\Http\Controllers\ReportsController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('dashboard');
});




Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    // Inventory routes
    Route::prefix('inventory')->name('inventory.')->group(function () {
        Route::get('/', [InventoryController::class, 'dashboard'])->name('dashboard')->middleware('permission:view-inventory');
        Route::get('/raw-materials', [InventoryController::class, 'rawMaterials'])->name('raw-materials')->middleware('permission:view-inventory');
        Route::get('/products', [InventoryController::class, 'products'])->name('products')->middleware('permission:view-inventory');
        Route::post('/add-stock', [InventoryController::class, 'addRawMaterialStock'])->name('add-stock')->middleware('permission:manage-inventory');
        Route::get('/orders/{order}/check-stock', [InventoryController::class, 'checkOrderStock'])->name('check-stock')->middleware('permission:view-inventory');
        Route::post('/orders/{order}/process', [InventoryController::class, 'processOrder'])->name('process-order')->middleware('permission:manage-inventory');
    });
    
    // Product routes
    Route::resource('products', ProductController::class)->middleware([
        'index' => 'permission:view-products',
        'show' => 'permission:view-products',
        'create' => 'permission:create-products',
        'store' => 'permission:create-products',
        'edit' => 'permission:edit-products',
        'update' => 'permission:edit-products',
        'destroy' => 'permission:delete-products'
    ]);
    
    // Raw Materials routes
    Route::resource('raw-materials', RawMaterialController::class)->middleware([
        'index' => 'permission:view-inventory',
        'show' => 'permission:view-inventory',
        'create' => 'permission:manage-inventory',
        'store' => 'permission:manage-inventory',
        'edit' => 'permission:manage-inventory',
        'update' => 'permission:manage-inventory',
        'destroy' => 'permission:manage-inventory'
    ]);
    
    // Order routes
    Route::resource('orders', OrderController::class)->middleware([
        'index' => 'permission:view-orders',
        'show' => 'permission:view-orders',
        'create' => 'permission:create-orders',
        'store' => 'permission:create-orders',
        'edit' => 'permission:edit-orders',
        'update' => 'permission:edit-orders',
        'destroy' => 'permission:delete-orders'
    ]);
    Route::get('/orders-returns', [OrderController::class, 'returns'])->name('orders.returns')->middleware('permission:view-orders');
    
    // Import routes
    Route::prefix('import')->name('import.')->group(function () {
        Route::get('/', [ImportController::class, 'index'])->name('index')->middleware('permission:import-inventory');
        Route::post('/excel', [ImportController::class, 'import'])->name('excel')->middleware('permission:import-inventory');
        Route::post('/products/excel', [ImportController::class, 'importProducts'])->name('products.excel')->middleware('permission:import-inventory');
        Route::post('/courier/excel', [ImportController::class, 'importCourier'])->name('courier.excel')->middleware('permission:import-inventory');
        Route::post('/returns/excel', [ImportController::class, 'importReturns'])->name('returns.excel')->middleware('permission:import-inventory');
        Route::get('/template', [ImportController::class, 'downloadTemplate'])->name('template')->middleware('permission:import-inventory');
        Route::get('/products/template', [ImportController::class, 'downloadProductTemplate'])->name('products.template')->middleware('permission:import-inventory');
        Route::get('/courier/template', [ImportController::class, 'downloadCourierTemplate'])->name('courier.template')->middleware('permission:import-inventory');
        Route::get('/returns/template', [ImportController::class, 'downloadReturnsTemplate'])->name('returns.template')->middleware('permission:import-inventory');
    });
    
    // Reports routes
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/', [ReportsController::class, 'index'])->name('index')->middleware('permission:view-orders');
        Route::get('/simple', [ReportsController::class, 'simple'])->name('simple')->middleware('permission:view-orders');
        Route::get('/export', [ReportsController::class, 'export'])->name('export')->middleware('permission:view-orders');
    });
});

require __DIR__.'/auth.php';
