<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <title><?php echo $__env->yieldContent('title', 'Inventory Management'); ?> - <?php echo e(config('app.name', 'Laravel')); ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        .sidebar {
            min-height: 100vh;
            background-color: #343a40;
        }
        .sidebar .nav-link {
            color: #adb5bd;
            padding: 0.75rem 1rem;
        }
        .sidebar .nav-link:hover {
            color: #fff;
            background-color: #495057;
        }
        .sidebar .nav-link.active {
            color: #fff;
            background-color: #007bff;
        }
        .main-content {
            background-color: #f8f9fa;
            min-height: 100vh;
        }
        .page-header {
            background-color: #fff;
            border-bottom: 1px solid #dee2e6;
            padding: 1rem 0;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="p-3">
                        <h4 class="text-white mb-4">
                            <i class="fas fa-warehouse me-2"></i>
                            Nutrinestt Portal
                        </h4>
                    </div>
                    
                    <nav class="nav flex-column">
                        <a class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('dashboard')); ?>">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        
                        <a class="nav-link <?php echo e(request()->routeIs('inventory.*') ? 'active' : ''); ?>" href="<?php echo e(route('inventory.dashboard')); ?>">
                            <i class="fas fa-boxes me-2"></i>Inventory
                        </a>
                        
                        <a class="nav-link <?php echo e(request()->routeIs('products.*') ? 'active' : ''); ?>" href="<?php echo e(route('products.index')); ?>">
                            <i class="fas fa-cube me-2"></i>Products
                        </a>
                        
                        <a class="nav-link <?php echo e(request()->routeIs('raw-materials.*') ? 'active' : ''); ?>" href="<?php echo e(route('raw-materials.index')); ?>">
                            <i class="fas fa-flask me-2"></i>Raw Materials
                        </a>
                        
                        <a class="nav-link <?php echo e(request()->routeIs('orders.*') ? 'active' : ''); ?>" href="<?php echo e(route('orders.index')); ?>">
                            <i class="fas fa-shopping-cart me-2"></i>Orders
                        </a>
                        
                        <a class="nav-link <?php echo e(request()->routeIs('import.*') ? 'active' : ''); ?>" href="<?php echo e(route('import.index')); ?>">
                            <i class="fas fa-file-import me-2"></i>Import
                        </a>
                        
                        <a class="nav-link <?php echo e(request()->routeIs('reports.*') ? 'active' : ''); ?>" href="<?php echo e(route('reports.index')); ?>">
                            <i class="fas fa-chart-line me-2"></i>Reports
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Top Navigation -->
                    <div class="page-header">
                        <div class="container-fluid">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h1 class="h3 mb-0"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></h1>
                                </div>
                                <div class="col-auto">
                                    <div class="dropdown">
                                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                            <i class="fas fa-user me-2"></i>
                                            <?php echo e(Auth::user()->name); ?>

                                            <span class="badge bg-<?php echo e(Auth::user()->isAdmin() ? 'danger' : (Auth::user()->isManager() ? 'primary' : 'secondary')); ?> ms-2">
                                                <?php if(Auth::user()->isAdmin()): ?>
                                                    Admin
                                                <?php elseif(Auth::user()->isManager()): ?>
                                                    Manager
                                                <?php else: ?>
                                                    User
                                                <?php endif; ?>
                                            </span>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li><a class="dropdown-item" href="<?php echo e(route('profile.edit')); ?>"><i class="fas fa-user-edit me-2"></i>Profile</a></li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="dropdown-item">
                                                        <i class="fas fa-sign-out-alt me-2"></i>Logout
                                                    </button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Page Content -->
                    <div class="container-fluid py-4">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\jtest\resources\views/layouts/app.blade.php ENDPATH**/ ?>