<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <!-- Welcome Message -->
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-body">
                <h3 class="card-title">Welcome, <?php echo e(Auth::user()->name); ?>!</h3>
                <p class="card-text">
                    <?php if(Auth::user()->isAdmin()): ?>
                        You have full administrative access to the system.
                    <?php elseif(Auth::user()->isManager()): ?>
                        You have management access to inventory, products, and orders.
                    <?php else: ?>
                        You have limited access to the system.
                    <?php endif; ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="col-12">
        <div class="row">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-inventory')): ?>
            <div class="col-md-3 mb-4">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <h5 class="card-title">Inventory</h5>
                        <p class="card-text">Manage your inventory and raw materials</p>
                        <a href="<?php echo e(route('inventory.dashboard')); ?>" class="btn btn-primary">
                            View Inventory
                        </a>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-products')): ?>
            <div class="col-md-3 mb-4">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <h5 class="card-title">Products</h5>
                        <p class="card-text">Manage your product catalog</p>
                        <a href="<?php echo e(route('products.index')); ?>" class="btn btn-success">
                            View Products
                        </a>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-orders')): ?>
            <div class="col-md-3 mb-4">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <h5 class="card-title">Orders</h5>
                        <p class="card-text">View and manage orders</p>
                        <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-info">
                            View Orders
                        </a>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('import-inventory')): ?>
            <div class="col-md-3 mb-4">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <h5 class="card-title">Import</h5>
                        <p class="card-text">Import data from Excel files</p>
                        <a href="<?php echo e(route('import.index')); ?>" class="btn btn-warning">
                            Import Data
                        </a>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Role Information -->
    <div class="col-12 mt-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Your Role & Permissions</h5>
                <div class="row">
                    <div class="col-md-6">
                        <h6>Current Role:</h6>
                        <span class="badge badge-<?php echo e(Auth::user()->isAdmin() ? 'danger' : (Auth::user()->isManager() ? 'primary' : 'secondary')); ?>">
                            <?php if(Auth::user()->isAdmin()): ?>
                                Administrator
                            <?php elseif(Auth::user()->isManager()): ?>
                                Manager
                            <?php else: ?>
                                User
                            <?php endif; ?>
                        </span>
                    </div>
                    <div class="col-md-6">
                        <h6>Key Permissions:</h6>
                        <div class="d-flex flex-wrap">
                            <?php if(Auth::user()->hasPermission('view-inventory')): ?>
                                <span class="badge badge-success mr-1 mb-1">View Inventory</span>
                            <?php endif; ?>
                            <?php if(Auth::user()->hasPermission('manage-inventory')): ?>
                                <span class="badge badge-success mr-1 mb-1">Manage Inventory</span>
                            <?php endif; ?>
                            <?php if(Auth::user()->hasPermission('view-products')): ?>
                                <span class="badge badge-success mr-1 mb-1">View Products</span>
                            <?php endif; ?>
                            <?php if(Auth::user()->hasPermission('create-products')): ?>
                                <span class="badge badge-success mr-1 mb-1">Create Products</span>
                            <?php endif; ?>
                            <?php if(Auth::user()->hasPermission('view-orders')): ?>
                                <span class="badge badge-success mr-1 mb-1">View Orders</span>
                            <?php endif; ?>
                            <?php if(Auth::user()->hasPermission('import-inventory')): ?>
                                <span class="badge badge-success mr-1 mb-1">Import Data</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\jtest\resources\views/dashboard.blade.php ENDPATH**/ ?>