

<?php $__env->startSection('title', 'Import Data'); ?>
<?php $__env->startSection('page-title', 'Import Data'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">


    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                
<!-- Navigation Tabs -->
<ul class="nav nav-tabs mb-4" id="importTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="orders-tab" data-bs-toggle="tab" data-bs-target="#orders" type="button" role="tab" aria-controls="orders" aria-selected="true">
            <i class="fas fa-shopping-cart me-2"></i>Import Orders
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="products-tab" data-bs-toggle="tab" data-bs-target="#products" type="button" role="tab" aria-controls="products" aria-selected="false">
            <i class="fas fa-box me-2"></i>Import Products
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="courier-tab" data-bs-toggle="tab" data-bs-target="#courier" type="button" role="tab" aria-controls="courier" aria-selected="false">
            <i class="fas fa-truck me-2"></i>Import Courier Data
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="returns-tab" data-bs-toggle="tab" data-bs-target="#returns" type="button" role="tab" aria-controls="returns" aria-selected="false">
            <i class="fas fa-undo me-2"></i>Import Returns
        </button>
    </li>
</ul>

<!-- Tab Content -->
<div class="tab-content" id="importTabsContent">
    
    <!-- Orders Import Tab -->
    <div class="tab-pane fade show active" id="orders" role="tabpanel" aria-labelledby="orders-tab">
        <div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Import Shopify Orders</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('import.excel')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="file" class="form-label">Select Excel File</label>
                        <input type="file" class="form-control" id="file" name="file" accept=".xlsx,.xls,.csv" required>
                        <div class="form-text">
                            Supported formats: .xlsx, .xls, .csv (Max size: 10MB)
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="deduct_inventory" value="1" id="deductInventory" checked>
                            <label class="form-check-label" for="deductInventory">
                                Automatically deduct raw materials from inventory
                            </label>
                            <div class="form-text">
                                When checked, the system will calculate and deduct raw materials based on product recipes. You'll be warned if stock is insufficient.
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-upload me-2"></i>Import Orders
                        </button>
                        <a href="<?php echo e(route('import.template')); ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-download me-2"></i>Download Template
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <?php if(session('import_results')): ?>
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Import Results</h5>
                </div>
                <div class="card-body">
                    <?php $results = session('import_results'); ?>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="text-center">
                                <h3 class="text-success"><?php echo e($results['orders_created'] ?? $results['success']); ?></h3>
                                <p class="text-muted">Orders Created</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h3 class="text-info"><?php echo e($results['line_items_created'] ?? 0); ?></h3>
                                <p class="text-muted">Line Items</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h3 class="text-warning"><?php echo e($results['skipped']); ?></h3>
                                <p class="text-muted">Skipped</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h3 class="text-danger"><?php echo e(count($results['errors'])); ?></h3>
                                <p class="text-muted">Errors</p>
                            </div>
                        </div>
                    </div>

                    <?php if(!empty($results['inventory_warnings'])): ?>
                        <div class="mt-3">
                            <h6>Inventory Warnings:</h6>
                            <div class="alert alert-warning">
                                <ul class="mb-0">
                                    <?php $__currentLoopData = $results['inventory_warnings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warning): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($warning); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($results['errors'])): ?>
                        <div class="mt-3">
                            <h6>Errors:</h6>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php $__currentLoopData = $results['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Import Instructions</h5>
            </div>
            <div class="card-body">
                <h6>Required Columns (Mandatory):</h6>
                <ul class="small mb-3">
                    <li><strong>Name</strong> - Order number/identifier</li>
                    <li><strong>Lineitem name</strong> - Product name</li>
                    <li><strong>Lineitem quantity</strong> - Quantity ordered</li>
                </ul>
                
                <h6>Recommended Columns:</h6>
                <p class="small text-muted mb-2">
                    Your Shopify export should also include:
                </p>
                <ul class="small">
                    <li><strong>Email</strong> - Customer email</li>
                    <li><strong>Billing Name</strong> - Customer name</li>
                    <li><strong>Financial Status</strong> - Payment status</li>
                    <li><strong>Fulfillment Status</strong> - Fulfillment status</li>
                    <li><strong>Lineitem sku</strong> - Product SKU</li>
                    <li><strong>Lineitem price</strong> - Unit price</li>
                    <li><strong>Total</strong> - Order total</li>
                </ul>

                <div class="alert alert-info mt-3">
                    <small>
                        <strong>Shopify Format:</strong> Orders with multiple products will have multiple rows. Common data (Name, Email, Total) appears only on the first row.
                    </small>
                </div>
                
                <div class="alert alert-warning mt-3">
                    <small>
                        <strong>Auto-Creation:</strong> Products that don't exist will be created automatically. Make sure to configure their raw material recipes for inventory tracking.
                    </small>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Recent Imports</h5>
            </div>
            <div class="card-body">
                <p class="text-muted small">Import history will be displayed here.</p>
            </div>
        </div>
    </div>
</div>
    </div>
    <!-- End Orders Import Tab -->
    
    <!-- Products Import Tab -->
    <div class="tab-pane fade" id="products" role="tabpanel" aria-labelledby="products-tab">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Import Products</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('import.products.excel')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="product-file" class="form-label">Select Excel File</label>
                                <input type="file" class="form-control" id="product-file" name="file" accept=".xlsx,.xls,.csv" required>
                                <div class="form-text">
                                    Supported formats: .xlsx, .xls, .csv (Max size: 10MB)
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-upload me-2"></i>Import Products
                                </button>
                                <a href="<?php echo e(route('import.products.template')); ?>" class="btn btn-outline-secondary">
                                    <i class="fas fa-download me-2"></i>Download Template
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <?php if(session('import_results')): ?>
                    <div class="card mt-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Import Results</h5>
                        </div>
                        <div class="card-body">
                            <?php $results = session('import_results'); ?>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="text-center">
                                        <h3 class="text-success"><?php echo e($results['success']); ?></h3>
                                        <p class="text-muted">Successfully Imported</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="text-center">
                                        <h3 class="text-warning"><?php echo e($results['skipped']); ?></h3>
                                        <p class="text-muted">Skipped</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="text-center">
                                        <h3 class="text-danger"><?php echo e(count($results['errors'])); ?></h3>
                                        <p class="text-muted">Errors</p>
                                    </div>
                                </div>
                            </div>

                            <?php if(!empty($results['errors'])): ?>
                                <div class="mt-3">
                                    <h6>Errors:</h6>
                                    <div class="alert alert-danger">
                                        <ul class="mb-0">
                                            <?php $__currentLoopData = $results['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Import Instructions</h5>
                    </div>
                    <div class="card-body">
                        <h6>Expected Excel Format:</h6>
                        <p class="small text-muted">
                            Your Excel file should include the following columns:
                        </p>
                        <ul class="small">
                            <li><strong>Name</strong> - Product name (required)</li>
                            <li><strong>Price</strong> - Product price (required)</li>
                        </ul>

                        <div class="alert alert-info mt-3">
                            <small>
                                <strong>Note:</strong> 
                                <ul class="mb-0 mt-2">
                                    <li>SKUs will be auto-generated from product names</li>
                                    <li>If a product with the same name exists, only the price will be updated</li>
                                    <li>Prices can include currency symbols (e.g., $29.99)</li>
                                </ul>
                            </small>
                        </div>
                        
                        <div class="alert alert-warning mt-3">
                            <small>
                                <strong>Tips:</strong>
                                <ul class="mb-0 mt-2">
                                    <li>Download the template for the correct format</li>
                                    <li>Ensure all rows have both Name and Price</li>
                                    <li>Empty rows will be skipped</li>
                                </ul>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Products Import Tab -->
    
    <!-- Courier Data Import Tab -->
    <div class="tab-pane fade" id="courier" role="tabpanel" aria-labelledby="courier-tab">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Import Courier Service Data</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('import.courier.excel')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="courier-file" class="form-label">Select Excel File</label>
                                <input type="file" class="form-control" id="courier-file" name="file" accept=".xlsx,.xls,.csv" required>
                                <div class="form-text">
                                    Upload the courier service sheet with shipping costs and tax deductions (Max size: 10MB)
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-upload me-2"></i>Import Courier Data
                                </button>
                                <a href="<?php echo e(route('import.courier.template')); ?>" class="btn btn-outline-secondary">
                                    <i class="fas fa-download me-2"></i>Download Template
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <?php if(session('import_results')): ?>
                    <div class="card mt-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Import Results</h5>
                        </div>
                        <div class="card-body">
                            <?php $results = session('import_results'); ?>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="text-center">
                                        <h3 class="text-success"><?php echo e($results['success']); ?></h3>
                                        <p class="text-muted">Orders Updated</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="text-center">
                                        <h3 class="text-warning"><?php echo e($results['skipped']); ?></h3>
                                        <p class="text-muted">Skipped</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="text-center">
                                        <h3 class="text-danger"><?php echo e(count($results['errors'])); ?></h3>
                                        <p class="text-muted">Errors</p>
                                    </div>
                                </div>
                            </div>

                            <?php if(!empty($results['updated_orders'])): ?>
                                <div class="mt-3">
                                    <h6>Updated Orders Details:</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Order Ref</th>
                                                    <th>Original</th>
                                                    <th>Shipping</th>
                                                    <th>Total</th>
                                                    <th>Deductions</th>
                                                    <th>Net Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $results['updated_orders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($order['order_ref']); ?></td>
                                                        <td>Rs.<?php echo e(number_format($order['original_amount'], 2)); ?></td>
                                                        <td>Rs.<?php echo e(number_format($order['shipping_charges'], 2)); ?></td>
                                                        <td>Rs.<?php echo e(number_format($order['total_with_shipping'], 2)); ?></td>
                                                        <td>Rs.<?php echo e(number_format($order['deductions'], 2)); ?></td>
                                                        <td><strong>Rs.<?php echo e(number_format($order['net_amount'], 2)); ?></strong></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if(!empty($results['errors'])): ?>
                                <div class="mt-3">
                                    <h6>Errors:</h6>
                                    <div class="alert alert-danger">
                                        <ul class="mb-0">
                                            <?php $__currentLoopData = $results['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Import Instructions</h5>
                    </div>
                    <div class="card-body">
                        <h6>Required Columns:</h6>
                        <p class="small text-muted">
                            Your courier service Excel file must include:
                        </p>
                        <ul class="small">
                            <li><strong>Order Ref.</strong> (exact, with dot) - Must match the Order ID in your system</li>
                            <li><strong>ShippingCharges</strong> - Delivery charges from courier</li>
                            <li><strong>GST</strong> - Goods and Services Tax deducted</li>
                            <li><strong>WH Inc.Tax (X%)</strong> - Withholding Income Tax (percentage may vary)</li>
                            <li><strong>WH SalesTax (X%)</strong> - Withholding Sales Tax (percentage may vary)</li>
                            <li><strong>NetAmount</strong> - Final amount you'll receive</li>
                        </ul>

                        <div class="alert alert-info mt-3">
                            <small>
                                <strong>How it works:</strong> 
                                <ul class="mb-0 mt-2">
                                    <li>System matches orders by Order Ref</li>
                                    <li>Updates each order with courier data</li>
                                    <li>Calculates total with shipping</li>
                                    <li>Shows net amount after all deductions</li>
                                </ul>
                            </small>
                        </div>
                        
                        <div class="alert alert-warning mt-3">
                            <small>
                                <strong>Important:</strong>
                                <ul class="mb-0 mt-2">
                                    <li>Orders must exist in the system before importing courier data</li>
                                    <li>Order Ref must exactly match the order ID</li>
                                    <li>All amounts should be in numbers (currency symbols will be removed)</li>
                                    <li>Tax column names should include percentage, e.g., "WH Inc.Tax (2%)"</li>
                                </ul>
                            </small>
                        </div>
                    </div>
                </div>

                <div class="card mt-3 bg-light">
                    <div class="card-body">
                        <h6 class="text-muted">Financial Summary</h6>
                        <p class="small mb-1">
                            <strong>Formula:</strong><br>
                            Net Amount = (Order Total + Shipping) - (GST + WH Inc.Tax + WH SalesTax)
                        </p>
                        <p class="small text-muted mb-0 mt-2">
                            Use this data for accurate financial reporting and reconciliation with courier services.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Courier Data Import Tab -->
    
    <!-- Returns Import Tab -->
    <div class="tab-pane fade" id="returns" role="tabpanel" aria-labelledby="returns-tab">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-warning bg-opacity-10">
                        <h5 class="card-title mb-0"><i class="fas fa-undo me-2"></i>Import Order Returns</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Important:</strong> This will mark orders as returned and restore inventory for the products in those orders. Use this for P&L reporting to track returned items.
                        </div>
                        
                        <form method="POST" action="<?php echo e(route('import.returns.excel')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="returns-file" class="form-label">Select Excel File</label>
                                <input type="file" class="form-control" id="returns-file" name="file" accept=".xlsx,.xls,.csv" required>
                                <div class="form-text">
                                    Upload Excel file with ORDER_REFERENCE_NUMBER column (Max size: 10MB)
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="restore_inventory" value="1" id="restoreInventory" checked>
                                    <label class="form-check-label" for="restoreInventory">
                                        Automatically restore inventory for returned items
                                    </label>
                                    <div class="form-text">
                                        When checked, the system will add back raw materials to inventory based on the products in returned orders.
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-upload me-2"></i>Import Returns
                                </button>
                                <a href="<?php echo e(route('import.returns.template')); ?>" class="btn btn-outline-secondary">
                                    <i class="fas fa-download me-2"></i>Download Template
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <?php if(session('import_results') && isset(session('import_results')['orders_marked_returned'])): ?>
                    <div class="card mt-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Import Results</h5>
                        </div>
                        <div class="card-body">
                            <?php $results = session('import_results'); ?>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="text-center">
                                        <h3 class="text-warning"><?php echo e($results['orders_marked_returned']); ?></h3>
                                        <p class="text-muted">Orders Marked as Returned</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="text-center">
                                        <h3 class="text-secondary"><?php echo e($results['skipped']); ?></h3>
                                        <p class="text-muted">Skipped</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="text-center">
                                        <h3 class="text-danger"><?php echo e(count($results['errors'])); ?></h3>
                                        <p class="text-muted">Errors</p>
                                    </div>
                                </div>
                            </div>

                            <?php if(!empty($results['returned_products'])): ?>
                                <div class="mt-4">
                                    <h6><i class="fas fa-box-open me-2"></i>Returned Products Summary:</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-striped">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>Product Name</th>
                                                    <th>SKU</th>
                                                    <th class="text-end">Total Quantity Returned</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $results['returned_products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($product['product_name']); ?></td>
                                                        <td><span class="badge bg-secondary"><?php echo e($product['sku']); ?></span></td>
                                                        <td class="text-end"><strong><?php echo e($product['total_quantity']); ?></strong></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if(!empty($results['inventory_restored'])): ?>
                                <div class="mt-3">
                                    <h6><i class="fas fa-warehouse me-2"></i>Inventory Restoration Details:</h6>
                                    <div class="alert alert-success">
                                        <ul class="mb-0">
                                            <?php $__currentLoopData = $results['inventory_restored']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $restored): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($restored['product_name']); ?>: +<?php echo e($restored['quantity']); ?> units (Order: <?php echo e($restored['order_ref']); ?>)</li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if(!empty($results['errors'])): ?>
                                <div class="mt-3">
                                    <h6>Errors:</h6>
                                    <div class="alert alert-danger">
                                        <ul class="mb-0">
                                            <?php $__currentLoopData = $results['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Import Instructions</h5>
                    </div>
                    <div class="card-body">
                        <h6>Required Column:</h6>
                        <p class="small text-muted">
                            Your Excel file must include:
                        </p>
                        <ul class="small">
                            <li><strong>ORDER_REFERENCE_NUMBER</strong> - Must exactly match the order ID in your system (e.g., #1001)</li>
                        </ul>

                        <div class="alert alert-warning mt-3">
                            <small>
                                <strong>How it works:</strong> 
                                <ul class="mb-0 mt-2">
                                    <li>System finds each order by reference number</li>
                                    <li>Marks the order status as "returned"</li>
                                    <li>Records the return date</li>
                                    <li>Restores inventory for all products in the order</li>
                                    <li>Tracks returned quantities for P&L reporting</li>
                                </ul>
                            </small>
                        </div>
                        
                        <div class="alert alert-info mt-3">
                            <small>
                                <strong>Important Notes:</strong>
                                <ul class="mb-0 mt-2">
                                    <li>Orders must exist in the system before processing returns</li>
                                    <li>Already returned orders will be skipped</li>
                                    <li>Inventory will be automatically restored based on order items</li>
                                    <li>Use returned orders data for P&L exclusions</li>
                                </ul>
                            </small>
                        </div>
                    </div>
                </div>

                <div class="card mt-3 bg-light">
                    <div class="card-body">
                        <h6 class="text-muted"><i class="fas fa-chart-line me-2"></i>P&L Reporting</h6>
                        <p class="small mb-0">
                            Returns are tracked separately and can be excluded from profit and loss calculations. The system maintains:
                        </p>
                        <ul class="small mt-2 mb-0">
                            <li>Which orders were returned</li>
                            <li>Return dates</li>
                            <li>Quantity of each product returned</li>
                            <li>Inventory restoration history</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Returns Import Tab -->
    
</div>
<!-- End Tab Content -->
                



    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\jtest\resources\views/import/index.blade.php ENDPATH**/ ?>